function slider_graph(R_it,new_R_it, num_trials,t_total,one_stim,all_stim,old_R_it,dt,sc_R_it)
    l_array = 1:num_trials;
    l = l_array(1);
    time_t = 1:dt:t_total;
    f = figure('rend','painters','pos',[300 100 1200 700]);
    p = uipanel('Parent',f,'BorderType','none'); 
  %   p.Title = sprintf('Network Dynamics during learning (Trial %d)',l);
    p.Title = 'Network Dynamics Before Learning';
    p.TitlePosition = 'centertop'; 
    p.FontSize = 12;
    p.FontWeight = 'bold';
    subplot(4,1,1,'Parent',p)
    set(0,'DefaultAxesColorOrder',brewermap(12,'Paired'));
    h = plot(time_t,old_R_it(1,:),...
        time_t,old_R_it(2,:),...
        time_t,old_R_it(3,:),...
        time_t,old_R_it(4,:),...
        time_t,old_R_it(5,:),...
        time_t,old_R_it(6,:),...
        time_t,old_R_it(7,:),...
        time_t,old_R_it(8,:)); 
    xticks([300 900 1300 2200]);
    axis([0 t_total 0 .3]);
    title('Excitatory');
    xlabel('Time(ms)'); 
    ylabel('Firing Rates');
    axis([0 t_total 0 .3]);
    subplot(4,1,2,'Parent',p)
    m = plot(time_t,one_stim(:,:,1));
    axis([0 t_total 0 1.5]);
    title('Stimulation');
    xlabel('Time(ms)'); 
    ylabel('Stimulation Strength (au)');
    subplot(4,1,3,'Parent',p)
    k = imagesc(sc_R_it(:,:,1));
%     title('Weight Matrix W_{ij}');
%     xlabel('Postsynaptic Population'); 
%     ylabel('Presynaptic Population');
    
%%
    r_p = uipanel('Parent',p,'Title','Learning Stage','FontSize',12,...
                  'Position',[0 0 .5 .25]);
    s_p = uipanel('Parent',p,'Title','Trial Number','FontSize',12,...
                  'Position',[.5 0 .5 .25], 'HandleVisibility', 'off');
           
    bg = uibuttongroup('Parent',r_p,'Position',[.2 .2 1 1],...
                    'SelectionChangedFcn',@bselection,...
                    'BorderType','none');

              
% Create three radio buttons in the button group.
    r1 = uicontrol(bg,'Style','radiobutton',...
                    'String','Before Learning',...
                    'Position',[120 90 100 40]);
              
    r2 = uicontrol(bg,'Style','radiobutton',...
                    'String','During Learning',...
                    'Position',[120 60 100 40]);

    r3 = uicontrol(bg,'Style','radiobutton',...
                    'String','After Learning ',...
                    'Position',[120 30 100 40]);
    slid = uicontrol('Parent', s_p, 'Style', 'slider','Min', 1, 'Max', numel(l_array), ...
                    'Value', 1, 'Position', [50 50 480 30],'SliderStep',[1/numel(l_array) 1/numel(l_array)], ...
                    'Callback', @react_to_slider, 'Visible', 'off');
    tex = uicontrol('Parent', s_p, 'Style', 'text', ...
                    'String', sprintf('Trial Number %d',l),...
                    'Position', [225 80 150 30],...
                    'FontSize', 18, 'Visible', 'off');            
%%            
    function bselection(bg,event)
        selection = get(event.NewValue, 'String');
        if selection == 'Before Learning'
           set(p,'Title','Network Dynamics Before Learning');
           s_p.HandleVisibility = 'off';
           slid.Visible = 'off';
           tex.Visible = 'off';
           NameArray = {'XData','YData'};
           ValueArray = {time_t, old_R_it(1,:);...
           time_t, old_R_it(2,:);...
           time_t, old_R_it(3,:);...
           time_t, old_R_it(4,:);...
           time_t, old_R_it(5,:);...
           time_t, old_R_it(6,:);...
           time_t, old_R_it(7,:);...
           time_t, old_R_it(8,:)};
           NameArray2 = {'XData','YData'};
           ValueArray2 = {time_t, one_stim(1,:,1);...
           time_t, one_stim(2,:,1);...
           time_t, one_stim(3,:,1);...
           time_t, one_stim(4,:,1);...
           time_t, one_stim(5,:,1);...
           time_t, one_stim(6,:,1);...
           time_t, one_stim(7,:,1);...
           time_t, one_stim(8,:,1)};
           set(h, NameArray,ValueArray);
           set(m, NameArray2,ValueArray2);
           set(k,'CData',sc_R_it(:,:,1));
        elseif selection == 'During Learning'
           s_p.HandleVisibility = 'on';
           slid.Visible = 'on';
           tex.Visible = 'on';
           NameArray = {'XData','YData'};
           ValueArray = {time_t, new_R_it(1,:,l);...
           time_t, new_R_it(2,:,l);...
           time_t, new_R_it(3,:,l);...
           time_t, new_R_it(4,:,l);...
           time_t, new_R_it(5,:,l);...
           time_t, new_R_it(6,:,l);...
           time_t, new_R_it(7,:,l);...
           time_t, new_R_it(8,:,l)};
           NameArray2 = {'XData','YData'};
           ValueArray2 = {time_t, all_stim(1,:,l);...
           time_t, all_stim(2,:,l);...
           time_t, all_stim(3,:,l);...
           time_t, all_stim(4,:,l);...
           time_t, all_stim(5,:,l);...
           time_t, all_stim(6,:,l);...
           time_t, all_stim(7,:,l);...
           time_t, all_stim(8,:,l)};
           set(h, NameArray,ValueArray);
           set(m, NameArray2,ValueArray2);
           set(k,'CData',sc_R_it(:,:,l));
           set(p,'Title',sprintf('Network Dynamics during learning (Trial %d)',l));
           @react_to_slider;
        else
           set(p,'Title',sprintf('Network Dynamics After Learning for %d Trials', num_trials));
           s_p.HandleVisibility = 'off';
           slid.Visible = 'off';
           tex.Visible = 'off';
           NameArray = {'XData','YData'};
           ValueArray = {time_t, R_it(1,:);...
           time_t, R_it(2,:);...
           time_t, R_it(3,:);...
           time_t, R_it(4,:);...
           time_t, R_it(5,:);...
           time_t, R_it(6,:);...
           time_t, R_it(7,:);...
           time_t, R_it(8,:)};
           NameArray2 = {'XData','YData'};
           ValueArray2 = {time_t, one_stim(1,:,num_trials+1);...
           time_t, one_stim(2,:,num_trials+1);...
           time_t, one_stim(3,:,num_trials+1);...
           time_t, one_stim(4,:,num_trials+1);...
           time_t, one_stim(5,:,num_trials+1);...
           time_t, one_stim(6,:,num_trials+1);...
           time_t, one_stim(7,:,num_trials+1);...
           time_t, one_stim(8,:,num_trials+1)};
           set(h, NameArray,ValueArray);
           set(m, NameArray2,ValueArray2);
           set(k,'CData',sc_R_it(:,:,num_trials+1));
       end
    end



%%
    function react_to_slider(source, event2)   %nested !!
        val = get(source, 'Value');
        l = l_array(round(val));
        set(source, 'Value', val);
        set(p,'Title',sprintf('Network Dynamics during learning (Trial %d)',l));
        NameArray = {'XData','YData'};
        ValueArray = {time_t, new_R_it(1,:,l);...
           time_t, new_R_it(2,:,l);...
           time_t, new_R_it(3,:,l);...
           time_t, new_R_it(4,:,l);...
           time_t, new_R_it(5,:,l);...
           time_t, new_R_it(6,:,l);...
           time_t, new_R_it(7,:,l);...
           time_t, new_R_it(8,:,l)};
        set(h, NameArray,ValueArray);
        set(k,'CData',sc_R_it(:,:,l));
        set(tex,'String',sprintf('Trial Number %d',l));
    end
%%
end